# reformat_fasta.pl
# 
# The purpose of this script is to reformat a FASTA file into a form that is used in subsequent 
# data pre-processing. The program takes as its command line input:
# in - the full path to the input FASTA file
# out - the full path to the output FASTA file
#
# The output of the file is in the form identifier line followed by a single line containing 
# the sequence for each of the sequences in the file.  
#
# Author : Brittney (Hinds) Keel
#
# Date created : 3 Feb 2013
# Last modified : 4 Feb 2013


use strict;
use Getopt::Long;


# Start by gathering command line options.

my $input;
my $output;
my $help; 

if (@ARGV > 0 ) { # if command line options supplied
  my $opt = GetOptions('help!',   \$help,
                       'in:s',    \$input,
	               'out:s',   \$output);
} else {
   print "Usage of this script:\n";
   print "Please supply command line options.\n";  
   print "Example: ./reformat_fasta.pl -in input -out output \n";
   exit;
}


if ($help)  { # if user requests help
  print "Usage of this script:\n";
  print "Please supply command line options.\n";  
  print "Example: ./reformat_fasta.pl -in input -out output \n";
  exit;
}




# Generate the reformatted FASTA file.

my $count_input = 0;
my $line_first_value = 0;
my $line = 0;

my $INPUT;
my $infile = '<'."$input"; # creates the read-only input file name
open($INPUT, $infile) or die "Can't open input file: $infile";

my $OUTPUT;
my $outfile = '>'."$output"; # creates the writable output file name
open($OUTPUT, $outfile) or die "Can't open output file: $outfile";

while ($line = readline($INPUT)) {
      $line_first_value = substr($line, 0, 1);
      if ($line_first_value eq '>' && $count_input == 0) { 
         print $OUTPUT "$line";
  	 $count_input++;
      }
      elsif ($line_first_value eq '>' && $count_input > 0) {
	 print $OUTPUT "\n$line";
  	 $count_input++;
      }
      else {
         chomp $line;
	 print $OUTPUT "$line";
      }
}

close($INPUT) or die "Can't close input file: $infile";
close($OUTPUT) or die "Can't close output file: $outfile";
