function [A,goodprots,badprots] = matrixcreate(r,dir)

% This script creates the m x m matrix where each row is a solution vector
% of one protein. Within the script the proteins with no solution are removed
% (that is their columns). 
%
% The program takes as its input:
% r = the number of taxa in the network
% dir = the directory where the solution files are stored
%
% The program outputs:
% A = matrix
% goodprots = list of indices of proteins in the network that had solutions
% badprots = list of indices of proteins that did not have solutions
%
% Author : Brittney (Hinds) Keel
% Date created : 29 July 2013
% Last modified : 2 Jan 2015

counter = 1; 
badcounter = 1;

A = zeros(r,r+1);
goodprots = zeros(1,r);
badprots = zeros(1,r);
for h = 1:r
  g = 0;
  matrix = sprintf('Solution%d.mat', h);
  tableFilename = strcat(dir, matrix); % the full path to the solution file
  load(tableFilename)
  
  %if g == 0 % if the solution exists 
  checkS = exist('S');
  if checkS == 0
      S = 'no solution';
  end
  
  t = strcmp('no solution',S);
  gg = strcmp('no solution',g);
  if gg == 0 && t == 0 % if the solution exists
    A(counter,:) = S(1,:); % add solution vector (first row of S) to the matrix
    goodprots(1,counter) = h; % add index to list of good proteins
 
    clear S
    clear g
    counter = counter+1; % increments the counter
  else % if solution does not exist
    badprots(1,badcounter) = h; % add index to bad protein list
    badcounter = badcounter+1; % increments the counter
  end
end

A(:,1)=[]; % removes the first column of the output matrix (the zero placeholder)
A(counter:end, :) = []; % removes extra rows of the matrix (these exist do to pre-allocation of memory)
goodprots(counter:end) = []; % removes extra positions of the array (these exist do to pre-allocation of memory)
badprots(badcounter:end) = []; % removes extra positions of the array (these exist do to pre-allocation of memory)

A(:,badprots)=[]; % remove columns of bad proteins from matrix


