function make_cytoscape_file(r,dir,outfile,thresh,iso)

% This script creates a tab-delimited text file that is in the format of a weighted edge
% network for the program Cytoscape. 
%
% The program takes as its input:
% r = total number of taxa in the network
% dir = the directory where the solution files are stored and where the
%       output file will be saved
% outfile = the name of the output file
% thresh = the edge weight threshold for edge inclusion (thresh=0 means use
%          all edges, thresh=0.1 means use all edges with weight>0.1, etc.)
% iso = indicator whether or not to print isolated nodes (1 if yes, 0 if
%       no)
%
% The program outputs the text file into the specified directory.
%
% SPECIAL NOTE: The file that is written is an appendable file. Therefore if you run 
%               the program more than once, you need to delete the cytoscape file
%               between runs (otherwise it will just continually append the one file).
%
% Author : Brittney (Hinds) Keel
% Date created : 6 May 13
% Last modified : 26 Feb 15
 
filename = strcat(dir, outfile); 
fid = fopen(filename,'at');  % Note the 'at' for an appendable in text mode (opens appendable file)
fprintf(fid, '%s\t%s\t%s\t%s\n', 'Target', 'Source', 'Weight', 'GV');

for h = 1:r 
   S = []; 
   matrix = sprintf('Solution%d.mat', h);                           
   tableFilename = strcat(dir,matrix); % full path to solution file                                  
   load(tableFilename); 
   
   checkS = isempty(S); % check if solution exists
   
   if checkS == 0  
      [r, ~] = size(S);
      if r == 2
         if iso == 1
         fprintf(fid,'%s%d\n','P',h);
         end
      else
      t = strcmp('no solution',S);
      if t == 1 
         if iso == 1
         fprintf(fid,'%s%d\n','P',h);
         end
      else   
      gv = S(3,3); % the game value
      end
      end
      t = S(1,:); % the first row of the matrix
      t(1) = []; % removes zero placeholder
      
      checkiso = 0;
      for j = 1:length(t) % loop over row
         if t(j)>thresh % if weight is above lower threshold
             fprintf(fid,'%s%d\t%s%d\t%.4f\t%.4f\n','P',h,'P',j,t(j),gv); % print to file
         else
             checkiso = checkiso + 1;
         end
      end
      
      if checkiso == length(t)
          if iso == 1
          fprintf(fid,'%s%d\n','P',h);
          end
      end
   elseif iso == 1 % if no solution print an isolated node
       fprintf(fid,'%s%d\n','P',h);
   end
end