function [weakclusters,goodprots,badprots] = findgraphclusters(r,dir)

% This script finds the clusters in the network graph. It uses Matlab's
% graphconncomp function (need Matlab 2013 or newer). 
%
% The function takes as its input:
% r = number of taxa
% dir = directory where the solution files are stored
%
% The program outputs:
% weakclusters = cell array of graph clusters (weakly connected graph components)
% goodprots = array of indices of proteins that have game theory solutions
% badprots = array of indices of proteins that did not have game theory
%            solutions (LP didn't converge, all rows linearly dependent,
%            etc)
% 
% Author: Brittney (Hinds) Keel
% Date created: 29 July 2013
% Last modified : 2 Jan 2015

[A, goodprots, badprots] = matrixcreate(r,dir); % creates matrix of solutions for valid proteins
G = sparse(A); % sparse representation of A
[S1, C1] = graphconncomp(G,'Directed', true,'Weak', true); % finds weakly connected components

for i = 1:S1 % loops over the number of clusters found
    p = []; 
    c = find(C1(:)==i); % finds the proteins that exist in this cluster
    for j = 1:length(c) 
        h = goodprots(c(j)); % gives the index of the protein (full index system contains ALL proteins)
        p = [p h]; % adds the index to the listing for the cluster
    end
    
    weakclusters{i} = p; % adds the vector of indices to the cell array of clusters
end

g = length(badprots);
h = length(weakclusters);

count = 1;
for i = 1:g
    pr = badprots(i);
    weakclusters{h+count} = [pr];
    count = count+1;
end