#!/usr/bin/perl
# filter_hmmer.pl

# The purpose of this script is to filter the HMMER output results for a given E-value threshold.

# Author         : Brittney (Hinds) Keel
# Date created   : 29 Aug 2014
# Last modified  : 29 May 2014

use strict;
use Getopt::Long;


# Start by gathering command line options.
my $in;
my $out;
my $evalthresh;
my $help;


if (@ARGV > 0) { # if command line options are supplied
   my $opt = GetOptions('help!', \$help,
                        'in:s',  \$in,
                        'out:s', \$out,
                        'e:s',   \$evalthresh);
} else { 
   print "Usage of this script:\n";
   print "Please supply command line options.\n";
   print "Example : ./filter_hmmer.pl -in inhmmerfile -out outhmmerfile -e evalthresh\n";
   exit;
}


if ($help) { # if the user requests help
   print "Usage of this script:\n";
   print "Please supply command line options.\n";
   print "Example : ./filter_hmmer.pl -in inhmmerfile -out outhmmerfile -e evalthresh\n";
   exit;

}


# Read in Hmmer domain table and print only those domains meeting the E-value threshold to the output file.
my $hmmer_file = "<"."$in"; 
my $out_file = ">"."$out";

my $INPUT_FILE;
my $OUTPUT_FILE;

open($INPUT_FILE, $hmmer_file) or die "Can't open input file : $hmmer_file";
open($OUTPUT_FILE, $out_file) or die "Can't open file: $out_file";


my $first_line = readline($INPUT_FILE); # the header line of the file
print $OUTPUT_FILE "$first_line";
my $second_line = readline($INPUT_FILE); # another header line
print $OUTPUT_FILE "$second_line";
my $third_line = readline($INPUT_FILE); # another header line
print $OUTPUT_FILE "$third_line";

while (my $line = readline($INPUT_FILE)) {
   if (!($line =~ m/^#/)) {
      my @line_vals = split /\s+/, $line;
      my $eval = $line_vals[12]; # the domain E-value (use the i-Evalue)

      
     if (($eval+0) < $evalthresh) { # if E-value is below the threshold
        print $OUTPUT_FILE "$line";
     }

   }
}           
			
close($INPUT_FILE) or die "Can't close file : $hmmer_file";
close($OUTPUT_FILE) or die "Can't close file : $out_file";
