function D = domainmatrix(goodprots,mdir,sdir,v)

% This script creates the matrix to be colored in the domain profile image
% creation. 
%
% The program takes as its input:
% goodprots = list of proteins that have solutions
% mdir = matrix directory
% sdir = solution directory
% v = the set of domain labels
%
% The program outputs:
% D = the matrix of domain weight info
%
% Author : Brittney (Hinds) Keel
% Date created : 29 July 2013
% Last modified : 2 Jan 2015

for y = 1:length(goodprots)
  h = goodprots(y);
  mtx = sprintf('%d_mtx.txt', h);
  matrixFilename = strcat(mdir,mtx); % full path to distance matrix file
  sol = sprintf('Solution%d.mat', h); 
  solutionFilename = strcat(sdir,sol); % full path to solution file
  
  Solution = load(solutionFilename); % loads solution 
  Matrix = importdata(matrixFilename); % loads distance matrix
  
  T = Solution.S; % the solution matrix  
  doms = Matrix.textdata; % the vector of domain identifiers that exist on the protein
  
  [k, ~] = size(T);
  col = T(2:k,1); % removes the zero placeholder in the (1,1) matrix position 
  col = col';
  row = [];
  
  for j = 1:length(v)
      d = v(j); % the domain ID
      ind = find(ismember(doms,d)); % determine if protein has this domain
      t = isempty(ind); % see if index of domain is empty
      
      if t == 1 % if domain not present 
        row = [row NaN]; % assign entry to be NaN
      else % if domain present
        row = [row col(ind)]; % assign entry to be the diversity weight
      end
  end
  
  D(y,:) = row; % add row to the output matrix
end