function [avgvalue,s]=clustersortaverage(c,goodprots,sdir)

% This script sorts the graph clusters according to their average game
% value. 
%
% The program takes as its input:
% c = cell array of graph clusters
% goodprots = list of proteins that have solutions
% sdir = solution directory
%
% The program outputs:
% avgvalue = the vector of average game values in descending order
% s = the cell array of corresponding ordered clusters
%
% Author : Brittney (Hinds) Keel
% Date created: 29 July 2013
% Last modified : 2 Jan 2015


for i = 1:length(goodprots) 
    w = goodprots(i); % the protein index
    w
    sortmatrix(i,2) = w; % sets value of second column of matrix to be this index
    solution = sprintf('Solution%d.mat', w);
    tableFilename = strcat(sdir,solution); % full path to solution file
    Table=load(tableFilename);
    T = Table.S; % the solution matrix
    
    [Trow, Tcol] = size(T);
    
    if (Trow > 2)
    sortmatrix(i,1)=T(3,3); % sets value of the first column of the matrix to be the game value
    else 
        sortmatrix(i,1) = 0;
    end
end


for i = 1:length(c)
    x = c{i}; % the vector of cluster elements 
    sum = 0; % intializes the sum of the game values
    
    for j = 1:length(x)
        g = find(goodprots(:) == x(j)); % finds location of cluster element in goodprots vector
        q = sortmatrix(g,1); % the game value for this protein
        sum = sum+q; % adds to sum
        newsortmatrix(j,:) = sortmatrix(g,:); % adds row to new matrix to be sorted
    end
    avg = (sum)/(length(x)); % calculates the average 
    compare(i,:) = [avg i]; % matrix to compare average game values of the clusters
    newsortmatrix = sortrows(newsortmatrix); % sorts the rows of the matrix according to game value column
    newsortmatrix = flipud(newsortmatrix); % flips matrix (so values are in descending order)
    t{i} = newsortmatrix(:,2); % saves vector to cell array (proteins are sorted now)
    clear q 
    clear newsortmatrix 
end


compare = sortrows(compare); % sorts the clusters according to their average game value
compare = flipud(compare); % flips the order (so its in descending order)
y = compare(:,2); % the vector of sorted cluster numbers 

avgvalue = compare(:,1); % the vector of sorted average game values
for j = 1:length(y)
    k = y(j); % the cluster number (sorted) 
    s{j} = t{k}; % saves cluster vector to the sorted cell array
end
